// Jellybean Rain by maxoo
// https://www.shadertoy.com/view/7ltSzj
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
//#define iGlobalTime u_Elapsed* 0.3141592
//90 FOV
#define FOCAL_LENGTH 1.0 
#define iTime u_Elapsed* 0.366 
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0,0.0,0.0)
uniform sampler2D iChannel0;
//











float rand(float x) {
    return fract(sin(x)*1e5);
}

float noise(float x) {
    float i = floor(x);
    float f = fract(x);
    return mix(rand(i), rand(i + 1.0), smoothstep(0.0, 1.0, f));
}
void main( void )
// void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;

    vec3 color = vec3(0.0);
    
    uv.x *= 155.0;
    
    vec2 i =  floor(uv);
    
    uv.y *= max(6.5 * rand(i.x + 1.0), 0.02);
    
    float odd = step(1.0, mod(i.x, 2.0));
    float even = 1.0 - odd;
    
    uv.y += odd * pow(iTime, 0.52) * rand(i.x) * 5.0;
    uv.y += even * pow(iTime, 0.66) * rand(i.x) * 5.0;
    uv.y += iTime * 0.4;
    uv = fract(uv);
    
    float b = uv.x - uv.y + 0.3;
    
    color = vec3(noise(i.x + 1000.0) * b, noise(i.x + 30000.0 * 0.4) * b, noise(i.x) * b);
    
    // Output to screen
    gl_FragColor = vec4(color,1.0);
}




